/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/src/regexp.ph
 > Purpose:         Regular expression matcher - include definitions
 > Author:          Jonathan Meyer, July 10 1992
 > Documentation:   REF *REGEXP
 > Related Files:   SRC *VED_REGEXP_SEARCH.P REGEXP_SEARCH.P REGEXP_COMPILE.P
*/

;;; ------ REGULAR EXPRESSION MATCER DEFINES -------------------------------

lconstant
    macro (
        ;;; output opcodes generated by the compiler
        CBRA    = 2,
        CCHR    = 4,
        CDOT    = 8,
        CCL     = 12,
        CXCL    = 16,
        CDOL    = 20,
        CCEOF   = 22,
        CKET    = 24,
        CBRC    = 28,
        CLET    = 30,
        CBACK   = 36,
        NCCL    = 40,
        CCASE   = 44,
        NCCASE  = 46,

        STAR    = 01,
        RNGE    = 03,

        ;;; maximum of 9 bracketed expressions
        NBRA    = 9,

        ;;; Indexes to closures on Regexp_search
        CLOS_PROPS          = 1,    ;;; list of properties about regexp
        CLOS_BRASLIST       = 2,
        CLOS_BRAELIST       = 3,
        CLOS_BRAVLIST       = 4,
        CLOS_NBREAKS        = 5,
        CLOS_LENGTH         = 12, ;;; number of frozen arguments

        ;;; Contents of CLOS_PROPS field of Regexp_search closure -
        ;;; These things aren't used by Regexp_search but may be useful to
        ;;; user. See regexp_delimeter, regexp_subexp_count, regexp_anchored.
        PROPS_DELIM         = 1,
        PROPS_NBRA          = 2,
        PROPS_ANCHORED      = 3,
      ),
;
