/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 > File:            C.all/src/syscomp/lib.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

                GENERAL ROUTINES FOR SYSTEM COMPILATION

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

uses DEF;
uses DEFV;


section $-Popas;

global constant
    nullword = consword(nullstring);

define lconstant na_info(id, info_p);
    lvars id, procedure info_p;
    lconstant nap = writeable conspair(0, "nonactive");
    id -> fast_front(nap);
    info_p(nap)
enddefine;

global constant procedure (
    nonactive_isconstant    = na_info(%isconstant%),
    nonactive_isassignable  = na_info(%isassignable%),
    );

define global nonactive_identtype(id) -> type;
    lvars id, type = identtype(id);
    unless isident(type) then
        if isactive(id) then "procedure" -> type endif
    endunless
enddefine;

define global newactproperty(/* newproperty args */ active_dflt) -> prop;
    lvars active_dflt, prop;
    newproperty() -> prop;
    active_dflt -> property_active(prop)
enddefine;

global vars procedure asmf_charout;

define global asmf_pr(item);
    lvars item;
    dlocal cucharout = asmf_charout;
    if isstring(item) then
        ;;; a -discout- consumer can take a byte vector directly
        cucharout(item)
    else
        sys_syspr(item)
    endif
enddefine;

define asmf_printf();
    dlocal cucharout = asmf_charout, pr = asmf_pr;
    printf()
enddefine;

define outcode();
    asmf_printf('\t%s\n')
enddefine;


define subscr_nbyte(sub, string, n) -> val;
    lvars n, val = 0, sub, string;
    sub fi_+ n -> sub;
    repeat
        sub fi_- 1 -> sub;
        f_subs(sub, string) || val -> val;
        n fi_- 1 -> n;
        quitif(n == 0);
        val << 8 -> val
    endrepeat
enddefine;
;;;
define updaterof subscr_nbyte(val, sub, string, n);
    lvars n, val, sub, string;
    repeat
        val && 16:FF -> f_subs(sub, string);
        n fi_- 1 -> n;
        quitif(n == 0);
        sub fi_+ 1 -> sub;
        val >> 8 -> val
    endrepeat
enddefine;

vars w_buffer = nullstring;
sys_runtime_apply(procedure; inits(2048) -> w_buffer endprocedure);

define wbuf_insert_strword(index, string) -> index;
    lvars index, string, slen, wbuf = w_buffer;
    if (datalength(string) ->> slen) fi_>= 16:FF then
        mishap(string, 1, 'STRING EXCEEDS 254 CHARS -- TOO LONG FOR .W FILE')
    endif;
    slen -> f_subs(index, wbuf);
    index fi_+ 1 -> index;
    string -> substring(index, slen, wbuf);
    index fi_+ slen -> index;
    if index fi_+ 300 fi_> datalength(wbuf) then
        ;;; expand buffer
        inits(index << 1) -> wbuf;
        move_subvector(1, w_buffer, 1, wbuf, index fi_- 1);
        wbuf -> w_buffer
    endif
enddefine;

define wbuf_extract_strword(index, want_word);
    lvars index, len, want_word;
    f_subs(index, w_buffer) -> len;
    index fi_+ 1 -> index;
    index fi_+ len;             ;;; return next index
    if want_word then
        subword(index, len, w_buffer)
    elseif len == 0 then
        nullstring
    else
        substring(index, len, w_buffer)
    endif
enddefine;

define wbuf_extract_strwords(index, count, want_word);
    lvars index, count, want_word, item;
    fast_repeat count times
        wbuf_extract_strword(index, want_word) -> (index, item);
        item
    endrepeat;
    index
enddefine;

define global id_display_str(path, word);
    lvars path, word, p;
    if ispair(word_dict_status(word) ->> p) then
        section_pathname(destpair(p)) -> path -> word
    endif;
    if isword(path) then
        fast_word_string(path) -> path
    elseunless path then
        nullstring -> path
    endif;
    word_string(word) -> word;
    if datalength(word) /== 0 and word(1) == `\^_` then
        `_` -> word(1);
        word <> ' (NP)' -> word
    endif;
    if path = nullstring then
        word
    else
        unless isendstring('$-', path) then path <> '$-' -> path endunless;
        path <> word
    endif
enddefine;

#_IF not(DEF pop_undef)
lvars dummy, procedure dummyp;
constant $-pop_undef = dummy, $-pop_undef_p = dummyp;
#_ENDIF


    /*  List of unique structures generated by POPLINK.
        (WRUNIQ_NUMBER encoding on w-file is back of pair.)
    */
define global poplink_unique_struct =
    newproperty([   [%false,        conspair("false",       0)%]
                    [%true,         conspair("true",        1)%]
                    [%[],           conspair("nil",         2)%]
                    [%pop_undef,    conspair("pop_undef",   16:10)%]
                    [%pop_undef_p,  conspair("pop_undef_p", 16:11)%]
                ], 2, false, true)
enddefine;

endsection;     /* $-Popas */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Sep 12 1991
        Added temp definition for popautolist
--- John Gibson, Aug 30 1990
        Added temp definition of #| ... |#
--- John Gibson, Aug 27 1990
        Added temp definition of "weak"
--- John Gibson, May 17 1989
        popc version 13.6403 changes
--- John Gibson, Jan 29 1989
        New version of popc, split off sysint.p stuff
--- John Gibson, Feb 22 1988
        Moved DEF macro to beginning of file
--- John Gibson, Feb 14 1988
        Made definition of -nullstring- conditional on not being in system
        already.
--- John Gibson, Jan 17 1988
        Changes for coping with sections, weakrefs, new format for assembler
        files, etc, etc.
--- John Gibson, Aug 16 1987
        Added redefinition of sysVARS to exclude -vars- inside procedures
 */
