/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            C.all/src/undef.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:   REF *IDENT
 */

;;;----------------------- UNDEF RECORDS -----------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'gctypes.ph'

global constant
        procedure (Sys$- Eq__Fullrec1)
    ;


;;; -----------------------------------------------------------------------

section $-Sys =>    consundef, pop_undef, pop_undef_p, isundef,
                    undefword, undef_key;

    /*  Standard undefs -- generated by poplink
    */
constant
    pop_undef               = pop_undef,
    procedure pop_undef_p   = pop_undef_p,
    ;


define isundef(item);
    lvars item, _x;
    if iscompound(item)
    and ((item!KEY ->> _x) == undef_key
         or (_x == procedure_key
            and (item!PD_FLAGS ->> _x) _bitst _:M_PD_CLOSURE
            and _x _bitst _:M_PD_CLOS_UNDEF)
        ) then
        true
    else
        false
    endif
enddefine;

define undefword(urec);
    lvars urec;
    if isundef(urec) then
        ;;; dig out actual undef rec from closures
        while isprocedure(urec) do fast_frozval(1, urec) -> urec endwhile;
        urec!U_WORD
    else
        mishap(urec, 1, 'UNDEF RECORD NEEDED')
    endif
enddefine;
;;;
define updaterof undefword() with_nargs 2;
    mishap(2, 'CANNOT ALTER UNDEF RECORD')
enddefine;


;;; --- UNDEF KEY ------------------------------------------------------

define consundef(item) -> urec;
    lvars urec, item;
    Get_record(undef_key) -> urec;
    item -> urec!U_WORD
enddefine;

define lconstant Undef_print() with_nargs 1;
    Default_print(dup(), ()!U_WORD)
enddefine;

constant
    undef_key = struct KEY_R =>> {%
        _NULL,                  ;;; K_GC_RELOC
        key_key,                ;;; KEY
        _:M_K_SPECIAL_RECORD _biset _:M_K_COPY _biset _:M_K_NONWRITEABLE,
                                ;;; K_FLAGS
        _:GCTYPE_FULLREC1,      ;;; K_GC_TYPE
        Rec1_getsize,           ;;; K_GET_SIZE

        "undef",                ;;; K_DATAWORD
        false,                  ;;; K_SPEC
        isundef,                ;;; K_RECOGNISER
        WREF Exec_nonpd,        ;;; K_APPLY
        Eq__Fullrec1,           ;;; K_SYS_EQUALS
        WREF Eq__Fullrec1,      ;;; K_EQUALS
        Undef_print,            ;;; K_SYS_PRINT
        WREF Undef_print,       ;;; K_PRINT
        WREF Fullrec1_hash,     ;;; K_HASH

        _:NUMTYPE_NON_NUMBER,   ;;; K_NUMBER_TYPE
        _:PROLOG_TYPE_OTHER,    ;;; K_PLOG_TYPE
        _:EXTERN_TYPE_NORMAL,   ;;; K_EXTERN_TYPE
        _0,                     ;;; K_SPARE_BYTE

        @@(struct UNDEF)++,     ;;; K_RECSIZE_R
        false,                  ;;; K_CONS_R
        false,                  ;;; K_DEST_R
        false,                  ;;; K_ACCESS_R
        %};

endsection;     /* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Jan 15 1996
        Changed undef_key so that undefs are no longer a recordclass (which
        they clearly shouldn't be)
--- John Gibson, Apr  7 1995
        Revised key layout
--- John Williams, Mar 25 1993
        Changed lconstant "Cons_undef" to exported consundef
--- John Gibson, Oct 31 1992
        Added pop_undef and pop_undef_p
--- John Williams, Feb 11 1991
        Given -undefword- a dummy updater (so that -fill- doesn't
        produce a system error when applied to an undef).
--- John Gibson, Mar 14 1990
        Change to key layout.
--- John Gibson, Dec  4 1989
        Changes for new pop pointers
--- John Gibson, Feb  3 1989
        Changes to undef closures, got rid of undef_anon and undefp_anon.
--- John Gibson, Dec  7 1988
        Removed check in -Cons_undef- for arg being a token.
 */
